/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.utils;

public class ConvertUtils {
    static final char[] hexArrayUpper = "0123456789ABCDEF".toCharArray();
    static final char[] hexArrayLower = "0123456789ABCDEF".toCharArray();

    public static String byteToHex(byte b) {
        char[] hexChars = new char[2];
        int v = b & 0xFF;
        hexChars[0] = hexArrayUpper[v >>> 4];
        hexChars[1] = hexArrayUpper[v & 0xF];
        return new String(hexChars);
    }

    public static String bytesToHex(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArrayUpper[v >>> 4];
            hexChars[j * 2 + 1] = hexArrayUpper[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String bytesToHex(byte[] bytes, boolean isUpperCase) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            if (isUpperCase) {
                hexChars[j * 2] = hexArrayUpper[v >>> 4];
                hexChars[j * 2 + 1] = hexArrayUpper[v & 0xF];
                continue;
            }
            hexChars[j * 2] = hexArrayLower[v >>> 4];
            hexChars[j * 2 + 1] = hexArrayLower[v & 0xF];
        }
        return new String(hexChars);
    }

    public static byte hexToByte(String inHex) {
        return (byte)Integer.parseInt(inHex, 16);
    }

    public static byte[] hexToByteArray(String inHex) {
        byte[] result;
        int hexlen = inHex.length();
        if (hexlen % 2 == 1) {
            result = new byte[++hexlen / 2];
            inHex = "0" + inHex;
        } else {
            result = new byte[hexlen / 2];
        }
        int j = 0;
        for (int i = 0; i < hexlen; i += 2) {
            result[j] = ConvertUtils.hexToByte(inHex.substring(i, i + 2));
            ++j;
        }
        return result;
    }
}

